/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.util.Localizer;

public class CustomerRequest
extends MaterialRequest {
    private State state;
    private int priority;

    public CustomerRequest(String id, Material material, long dueDate, double qty, int priority) {
        super(id, dueDate, material, -qty);
        Preconditions.checkArgument(qty > 0.0, "Quantity of CustomerRequset must be positive.");
        Preconditions.checkArgument(priority >= 1 && priority <= 10, "Priority of CustomerRequest must be between 1 and 10.");
        this.priority = priority;
        this.state = State.ACTIVE;
    }

    public CustomerRequest(String id, Material material, long dueDate, double qty, int priority, State state) {
        this(id, material, dueDate, qty, priority);
        this.state = state;
        this.storeAct.setType(CustomerRequest.getStoreType(state));
    }

    @Override
    public double getQty() {
        return -this.getStoreActivity().getQty();
    }

    @Override
    public void setQty(double qty) {
        Preconditions.checkArgument(qty > 0.0, "Quantity of CustomerRequset must be positive.");
        this.setSaQty(-qty);
    }

    public boolean isRequestsProduction() {
        return this.getMaterial() instanceof Product;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        Preconditions.checkNotNull(state);
        Plan plan = this.storeAct.getPlan();
        this.removeSaFromPlan();
        this.storeAct.setType(CustomerRequest.getStoreType(state));
        this.state = state;
        this.addSaToPlan(plan);
    }

    public String toString() {
        return "CustomerRequest(" + this.getId() + ", " + this.getMaterial().getName() + ", " + this.getTime() + ", " + this.getQty() + ")";
    }

    private static StoreType getStoreType(State state) {
        switch (state) {
            case ACTIVE: {
                return StoreType.INPLAN_ACTUAL;
            }
            case INACTIVE: {
                return StoreType.INPLAN_POSSIBLE;
            }
        }
        throw new IllegalStateException();
    }

    public static enum State {
        ACTIVE,
        INACTIVE;


        public String toString() {
            switch (this) {
                case ACTIVE: {
                    return Localizer.getString("customer_request.state.active");
                }
                case INACTIVE: {
                    return Localizer.getString("customer_request.state.inactive");
                }
            }
            throw new IllegalStateException();
        }
    }
}

